import { createBrowserRouter } from "react-router";
import { Layout } from "./components/Layout";
import { Dashboard } from "./components/Dashboard";
import { Messages } from "./components/Messages";
import { Comments } from "./components/Comments";
import { Settings } from "./components/Settings";
import { Users } from "./components/Users";

export const router = createBrowserRouter([
  {
    path: "/",
    Component: Layout,
    children: [
      { index: true, Component: Dashboard },
      { path: "messages/:channelId?", Component: Messages },
      { path: "comments/:channelId?", Component: Comments },
      { path: "users", Component: Users },
      { path: "settings", Component: Settings },
    ],
  },
]);