import { Message } from "../types";

// Generate large number of mock messages (simulating 4000-5000 messages)
export function generateLargeMessageDataset(count: number = 5000): Message[] {
  const channels = [
    { type: 'trendyol-product', name: 'Trendyol', category: 'Ürün Sorusu' },
    { type: 'trendyol-order', name: 'Trendyol', category: 'Sipariş Sorusu' },
    { type: 'hepsiburada-product', name: 'Hepsiburada', category: 'Ürün Sorusu' },
    { type: 'hepsiburada-order', name: 'Hepsiburada', category: 'Sipariş Sorusu' },
    { type: 'instagram-message', name: 'Instagram', category: 'Gelen Mesaj' },
    { type: 'facebook-message', name: 'Facebook', category: 'Gelen Mesaj' },
    { type: 'whatsapp', name: 'WhatsApp', category: '+90555 555 55 55' },
    { type: 'email', name: 'E-posta', category: 'info@test.com' },
    { type: 'ticimax', name: 'Ticimax', category: 'Destek Talebi' },
  ];

  const sampleMessages = [
    'Bu ürünün kargo ücreti var mı?',
    'Siparişim ne zaman gelecek?',
    'Ürün stokta var mı?',
    'Fatura gönderebilir misiniz?',
    'İade işlemi nasıl yapılıyor?',
    'Bu ürünün farklı rengi var mı?',
    'Kampanya ne zaman bitecek?',
    'Ürün orijinal mi?',
    'Kargo takip numarası alabilir miyim?',
    'Toplu alımda indirim var mı?',
    'Ürün garantisi kaç yıl?',
    'Beden tablosu var mı?',
    'Ürün ne zaman stoğa girecek?',
    'İndirim kuponu kullanabilir miyim?',
    'Ürün özellikleri nelerdir?',
    'Teslimat süresi ne kadar?',
    'Kapıda ödeme mevcut mu?',
    'Yurt dışına gönderim yapıyor musunuz?',
    'Ürün değişimi yapılabilir mi?',
    'Fiyat düşecek mi?',
  ];

  const names = [
    'Ahmet Yılmaz', 'Ayşe Demir', 'Mehmet Kaya', 'Zeynep Şahin', 'Mustafa Çelik',
    'Fatma Öztürk', 'Ali Yıldız', 'Emine Arslan', 'Hüseyin Aydın', 'Hatice Özkan',
    'İbrahim Koç', 'Elif Kara', 'Murat Aksoy', 'Şeyma Yavuz', 'Osman Demirtaş',
    'Merve Erdoğan', 'Emre Çetin', 'Seda Kurt', 'Burak Polat', 'Gizem Şen',
  ];

  // Ürün bilgileri pool
  const products = [
    {
      imageUrl: 'https://images.unsplash.com/photo-1631984564919-1f6b2313a71c?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
      name: 'Nike Air Max 270 Erkek Spor Ayakkabı',
      stockCode: 'NK-AM270-BK-42',
      brand: 'Nike',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1736616967588-d81fcd6f4d0a?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
      name: 'MacBook Pro 16" M3 Max 16GB RAM 512GB SSD',
      stockCode: 'APPLE-MBP16-M3-512',
      brand: 'Apple',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1674658556545-f18d4080ab6c?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
      name: 'Sony WH-1000XM5 Kablosuz Kulaklık',
      stockCode: 'SONY-WH1000XM5-BLK',
      brand: 'Sony',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1703034390224-f5f0a204abc7?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
      name: 'Apple Watch Series 9 GPS 45mm',
      stockCode: 'APPLE-WATCH-S9-45',
      brand: 'Apple',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1699265837122-7636e128b4b0?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
      name: 'Samsung Galaxy S24 Ultra 256GB',
      stockCode: 'SAMSUNG-S24U-256',
      brand: 'Samsung',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1707849730179-06c69cf22acc?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
      name: 'Canon EOS R6 Mark II Fotoğraf Makinesi',
      stockCode: 'CANON-EOSR6M2-BODY',
      brand: 'Canon',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1760509684262-4501bacfdcc7?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
      name: 'The North Face Borealis Sırt Çantası',
      stockCode: 'TNF-BOREALIS-BLK',
      brand: 'The North Face',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1601633792220-5497bdee603a?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
      name: 'Ray-Ban Aviator Classic Güneş Gözlüğü',
      stockCode: 'RB-AVIATOR-GOLD',
      brand: 'Ray-Ban',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1739190045027-8f2dc883c832?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
      name: 'De\'Longhi Dedica Espresso Kahve Makinesi',
      stockCode: 'DELONGHI-DEDICA-SLV',
      brand: 'De\'Longhi',
    },
    {
      imageUrl: 'https://images.unsplash.com/photo-1691707895389-18dbdf2b5514?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&w=1080',
      name: 'Dyson V15 Detect Kablosuz Süpürge',
      stockCode: 'DYSON-V15-DETECT',
      brand: 'Dyson',
    },
  ];

  // Talep başlıkları pool
  const ticketTitles = [
    'Ödeme sayfasında hata alıyorum',
    'Şifremi sıfırlayamıyorum',
    'Ürün resmi yüklenmiyor',
    'Sepete ürün ekleyemiyorum',
    'Kargo takip çalışmıyor',
    'İndirim kodu geçersiz',
    'Üyelik aktivasyonu yapamıyorum',
    'Fatura bilgilerimi güncelleyemiyorum',
    'Sipariş geçmişi görünmüyor',
    'E-posta bildirimleri gelmiyor',
  ];

  const messages: Message[] = [];

  for (let i = 0; i < count; i++) {
    const channel = channels[Math.floor(Math.random() * channels.length)];
    const name = names[Math.floor(Math.random() * names.length)];
    const message = sampleMessages[Math.floor(Math.random() * sampleMessages.length)];
    const minutesAgo = Math.floor(Math.random() * 10080); // Random time within last week
    const isUnread = Math.random() > 0.3; // 70% unread rate
    const timestamp = new Date(Date.now() - minutesAgo * 60000);

    // Context bilgisini oluştur
    let context = undefined;

    if (channel.type === 'trendyol-product' || channel.type === 'hepsiburada-product') {
      // Ürün bilgisi ekle
      const product = products[Math.floor(Math.random() * products.length)];
      context = {
        productInfo: product,
      };
    } else if (channel.type === 'trendyol-order' || channel.type === 'hepsiburada-order') {
      // Sipariş bilgisi ekle
      const daysAgo = Math.floor(Math.random() * 14) + 1; // 1-14 gün arası
      const orderPrefix = channel.type === 'trendyol-order' ? 'TR' : 'HB';
      context = {
        orderInfo: {
          orderNumber: `${orderPrefix}-2024-${String(100000 + i).slice(-6)}`,
          orderDate: new Date(Date.now() - daysAgo * 24 * 60 * 60000),
        },
      };
    } else if (channel.type === 'ticimax') {
      // Talep bilgisi ekle
      const ticketTitle = ticketTitles[Math.floor(Math.random() * ticketTitles.length)];
      context = {
        ticketInfo: {
          title: ticketTitle,
          date: timestamp,
        },
      };
    }

    messages.push({
      id: `msg-${i}`,
      channelType: channel.type as any,
      channelName: channel.name,
      channelCategory: channel.category,
      customerName: `${name} #${i}`,
      lastMessage: message,
      timestamp: timestamp,
      unread: isUnread ? Math.floor(Math.random() * 3) + 1 : 0,
      conversation: [
        {
          id: `conv-${i}-1`,
          sender: 'customer',
          content: message,
          timestamp: timestamp,
        },
      ],
      context: context,
    });
  }

  // Sort by timestamp (newest first)
  return messages.sort((a, b) => b.timestamp.getTime() - a.timestamp.getTime());
}