import { Outlet, Link, useLocation } from "react-router";
import { MessageSquare, LayoutDashboard, Settings, LogOut, MessageCircle, Users } from "lucide-react";
import { Button } from "./ui/button";

export function Layout() {
  const location = useLocation();

  return (
    <div className="flex h-screen bg-gray-50">
      {/* Sidebar */}
      <aside className="w-64 bg-white border-r border-gray-200 flex flex-col">
        <div className="p-6 border-b border-gray-200">
          <h1 className="text-xl font-semibold text-gray-900">Mesaj Yönetimi</h1>
          <p className="text-sm text-gray-500 mt-1">AI Destekli Panel</p>
        </div>

        <nav className="flex-1 p-4 space-y-2">
          <Link to="/">
            <Button
              variant={location.pathname === "/" ? "secondary" : "ghost"}
              className="w-full justify-start"
            >
              <LayoutDashboard className="mr-2 h-4 w-4" />
              Dashboard
            </Button>
          </Link>
          <Link to="/messages">
            <Button
              variant={location.pathname.startsWith("/messages") ? "secondary" : "ghost"}
              className="w-full justify-start"
            >
              <MessageSquare className="mr-2 h-4 w-4" />
              Mesajlar
            </Button>
          </Link>
          <Link to="/comments">
            <Button
              variant={location.pathname.startsWith("/comments") ? "secondary" : "ghost"}
              className="w-full justify-start"
            >
              <MessageCircle className="mr-2 h-4 w-4" />
              Yorumlar
            </Button>
          </Link>
          <Link to="/users">
            <Button
              variant={location.pathname === "/users" ? "secondary" : "ghost"}
              className="w-full justify-start"
            >
              <Users className="mr-2 h-4 w-4" />
              Kullanıcılar
            </Button>
          </Link>
          <Link to="/settings">
            <Button
              variant={location.pathname === "/settings" ? "secondary" : "ghost"}
              className="w-full justify-start"
            >
              <Settings className="mr-2 h-4 w-4" />
              Ayarlar
            </Button>
          </Link>
        </nav>

        <div className="p-4 border-t border-gray-200">
          <div className="flex items-center gap-3 mb-4">
            <div className="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center">
              <span className="text-sm font-semibold text-blue-600">AD</span>
            </div>
            <div className="flex-1">
              <p className="text-sm font-medium text-gray-900">Admin User</p>
              <p className="text-xs text-gray-500">admin@example.com</p>
            </div>
          </div>
          <Button variant="outline" className="w-full justify-start" size="sm">
            <LogOut className="mr-2 h-4 w-4" />
            Çıkış Yap
          </Button>
        </div>
      </aside>

      {/* Main Content */}
      <main className="flex-1 overflow-hidden">
        <Outlet />
      </main>
    </div>
  );
}